'use strict';

var utils = require('@motionone/utils');
var info = require('./info.cjs.js');
var index = require('./offsets/index.cjs.js');

function measure(container, target = container, info) {
    /**
     * Find inset of target within scrollable container
     */
    info.x.targetOffset = 0;
    info.y.targetOffset = 0;
    if (target !== container) {
        let node = target;
        while (node && node != container) {
            info.x.targetOffset += node.offsetLeft;
            info.y.targetOffset += node.offsetTop;
            node = node.offsetParent;
        }
    }
    info.x.targetLength =
        target === container ? target.scrollWidth : target.clientWidth;
    info.y.targetLength =
        target === container ? target.scrollHeight : target.clientHeight;
    info.x.containerLength = container.clientWidth;
    info.y.containerLength = container.clientHeight;
}
function createOnScrollHandler(element, onScroll, info$1, options = {}) {
    const axis = options.axis || "y";
    return {
        measure: () => measure(element, options.target, info$1),
        update: (time) => {
            info.updateScrollInfo(element, info$1, time);
            if (options.offset || options.target) {
                index.resolveOffsets(element, info$1, options);
            }
        },
        notify: utils.isFunction(onScroll)
            ? () => onScroll(info$1)
            : scrubAnimation(onScroll, info$1[axis]),
    };
}
function scrubAnimation(controls, axisInfo) {
    controls.pause();
    controls.forEachNative((animation, { easing }) => {
        var _a, _b;
        if (animation.updateDuration) {
            if (!easing)
                animation.easing = utils.noopReturn;
            animation.updateDuration(1);
        }
        else {
            const timingOptions = { duration: 1000 };
            if (!easing)
                timingOptions.easing = "linear";
            (_b = (_a = animation.effect) === null || _a === void 0 ? void 0 : _a.updateTiming) === null || _b === void 0 ? void 0 : _b.call(_a, timingOptions);
        }
    });
    return () => {
        controls.currentTime = axisInfo.progress;
    };
}

exports.createOnScrollHandler = createOnScrollHandler;
